//
//  Detecting_Pinch_GesturesViewController.m
//  Detecting Pinch Gestures
//
//  Created by Vandad Nahavandipoor on 15/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Detecting_Pinch_GesturesViewController.h"

@implementation Detecting_Pinch_GesturesViewController

@synthesize pinchGestureRecognizer;
@synthesize myBlackLabel;
@synthesize currentScale;

- (void) handlePinches:(UIPinchGestureRecognizer*)paramSender{
  
  if (paramSender.state == UIGestureRecognizerStateEnded){
    self.currentScale = paramSender.scale;
  } else if (paramSender.state == UIGestureRecognizerStateBegan &&
             self.currentScale != 0.0f){
    paramSender.scale = self.currentScale;
  }
  
  if (paramSender.scale != NAN &&
      paramSender.scale != 0.0){
    paramSender.view.transform = 
    CGAffineTransformMakeScale(paramSender.scale, 
                               paramSender.scale);
  }
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  self.view.backgroundColor = [UIColor whiteColor];
  
  CGRect labelRect = CGRectMake(0.0f,     /* X */
                                0.0f,     /* Y */
                                200.0f,   /* Szerokość. */
                                200.0f);  /* Wysokość. */  
  
  self.myBlackLabel = [[UILabel alloc] initWithFrame:labelRect];
  self.myBlackLabel.center = self.view.center;
  self.myBlackLabel.backgroundColor = [UIColor blackColor];
  
  /* Bez poniższego wiersza kodu procedura rozpoznawania gestu uszczypnięcia nie będzie działała. */
  self.myBlackLabel.userInteractionEnabled = YES;
  [self.view addSubview:self.myBlackLabel];
  
  /* Utworzenie procedury rozpoznawania gestu uszczypnięcia. */
  self.pinchGestureRecognizer =  [[UIPinchGestureRecognizer alloc] 
                                  initWithTarget:self
                                  action:@selector(handlePinches:)];
  
  /* Dodanie procedury rozpoznawania gestów do widoku. */
  [self.myBlackLabel 
   addGestureRecognizer:self.pinchGestureRecognizer];
  
}

- (void) viewDidUnload{
  [super viewDidUnload];
  self.myBlackLabel = nil;
  self.pinchGestureRecognizer = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
